/*
 * Decompiled with CFR 0.152.
 */
package mandelbrotNeu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mandelbrotNeu.MeineLeinwand;
import textFelderTools.MeinDoubleTextFeld;
import textFelderTools.MeinNatzahlTextFeld;

public class MandelbrotMengeGUI
extends JFrame {
    private static final long serialVersionUID = 954054127226423364L;
    private JPanel contentPane;
    JPanel pnlGrafik = new JPanel();
    MeineLeinwand malPanel;
    int imgBreite = 459;
    int imgHoehe = 405;
    int frmBreite = 660;
    int frmHoehe = 690;
    JComboBox<String> comboBoxAufloesung = new JComboBox();
    MeinDoubleTextFeld tfxa = new MeinDoubleTextFeld("-2,02");
    MeinDoubleTextFeld tfxe = new MeinDoubleTextFeld("0,7");
    MeinDoubleTextFeld tfya = new MeinDoubleTextFeld("-1,2");
    MeinDoubleTextFeld tfye = new MeinDoubleTextFeld("1,2");
    MeinNatzahlTextFeld tfItertiefe = new MeinNatzahlTextFeld("500", "10", "10000");
    MeinDoubleTextFeld tfcxJulia = new MeinDoubleTextFeld("-0,777");
    MeinDoubleTextFeld tfcyJulia = new MeinDoubleTextFeld("0,116");
    JCheckBox chckbxFarbig = new JCheckBox("farbig");
    JCheckBox chckbxGenauer = new JCheckBox("genauer");
    JComboBox<Integer> comboBoxHochgenau = new JComboBox();
    JCheckBox chckbxJuliamenge = new JCheckBox("Juliamenge");
    String sMAL = "\u00b7";
    JLabel lblAufloesung = new JLabel("Aufl\u00f6sung: " + this.imgBreite + this.sMAL + this.imgHoehe);
    JLabel lblSymmetrie = new JLabel("Symmetrie: keine");
    JLabel lblRechenzeit = new JLabel("Rechenzeit:");
    JLabel lblSchwarzePixels = new JLabel("0");
    JLabel lblMausposition = new JLabel("Maus:      ");
    JLabel lblFlaeche = new JLabel("Fl\u00e4che: ");
    int abtastRate;
    String symmetrieFall;
    static final int DIGITS = 75;
    static MathContext mContext = new MathContext(75);

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MandelbrotMengeGUI frame = new MandelbrotMengeGUI();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public MandelbrotMengeGUI() {
        this.setPreferredSize(new Dimension(700, 700));
        this.setTitle("\u00b4Mandelbrotmenge  Ac V3.5   1-2013 bis 03-2023");
        this.setDefaultCloseOperation(3);
        this.setSize(this.frmBreite, this.frmHoehe);
        this.setLocationRelativeTo(null);
        ImageIcon mandelIcon = new ImageIcon(MandelbrotMengeGUI.class.getResource("/mandelbrotNeu/icons/mandel.png"));
        this.setIconImage(mandelIcon.getImage());
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 3));
        this.contentPane.setBackground(new Color(230, 230, 250));
        this.setContentPane(this.contentPane);
        JPanel pnlSteuerung = new JPanel();
        pnlSteuerung.setBackground(new Color(224, 255, 255));
        this.contentPane.add((Component)pnlSteuerung, "North");
        JButton btnZeichne = new JButton("Start");
        btnZeichne.setFont(new Font("Arial", 1, 11));
        btnZeichne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MandelbrotMengeGUI.this.chckbxJuliamenge.isSelected()) {
                    MandelbrotMengeGUI.this.zeichneJuliamenge();
                } else {
                    MandelbrotMengeGUI.this.zeichneMandelbrotmenge();
                }
            }
        });
        pnlSteuerung.add(btnZeichne);
        JButton btnReset = new JButton("Reset");
        btnReset.setFont(new Font("Arial", 0, 11));
        btnReset.setToolTipText("alle Eingaben auf MandelbrotStartwerte zur\u00fccksetzen");
        btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MandelbrotMengeGUI.this.resetWerte();
            }
        });
        pnlSteuerung.add(btnReset);
        this.chckbxFarbig.setFont(new Font("Arial", 0, 10));
        this.chckbxFarbig.setOpaque(false);
        this.chckbxFarbig.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (MandelbrotMengeGUI.this.chckbxGenauer.isSelected()) {
                    MandelbrotMengeGUI.this.chckbxFarbig.setSelected(false);
                }
            }
        });
        pnlSteuerung.add(this.chckbxFarbig);
        this.chckbxGenauer.setFont(new Font("Arial", 0, 10));
        this.chckbxGenauer.setOpaque(false);
        this.chckbxGenauer.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (MandelbrotMengeGUI.this.chckbxGenauer.isSelected()) {
                    MandelbrotMengeGUI.this.chckbxFarbig.setSelected(false);
                }
            }
        });
        pnlSteuerung.add(this.chckbxGenauer);
        final int[] abtastRateFeld = new int[]{16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 10000};
        int i = 0;
        while (i < abtastRateFeld.length) {
            this.comboBoxHochgenau.addItem(abtastRateFeld[i]);
            ++i;
        }
        this.comboBoxHochgenau.setPreferredSize(new Dimension(55, 20));
        this.comboBoxHochgenau.setToolTipText("Zeichengenauigkeit");
        this.comboBoxHochgenau.setFont(new Font("Arial", 1, 10));
        this.comboBoxHochgenau.setBackground(new Color(255, 255, 224));
        this.comboBoxHochgenau.setSelectedIndex(1);
        this.abtastRate = 32;
        this.comboBoxHochgenau.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MandelbrotMengeGUI.this.abtastRate = abtastRateFeld[MandelbrotMengeGUI.this.comboBoxHochgenau.getSelectedIndex()];
            }
        });
        pnlSteuerung.add(this.comboBoxHochgenau);
        final JCheckBox chckbxAchsenZeichnen = new JCheckBox("Achsen ein");
        chckbxAchsenZeichnen.setOpaque(false);
        chckbxAchsenZeichnen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (chckbxAchsenZeichnen.isSelected()) {
                    MandelbrotMengeGUI.this.malPanel.macheBufKopie();
                    MandelbrotMengeGUI.this.zeichneAchsen();
                } else {
                    MandelbrotMengeGUI.this.malPanel.holeBufKopie();
                }
            }
        });
        chckbxAchsenZeichnen.setFont(new Font("Arial", 0, 10));
        pnlSteuerung.add(chckbxAchsenZeichnen);
        JButton btnSpeichern = new JButton();
        btnSpeichern.setPreferredSize(new Dimension(34, 34));
        btnSpeichern.setIcon(new ImageIcon(MandelbrotMengeGUI.class.getResource("/mandelbrotNeu/icons/speichern 32x32.png")));
        btnSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MandelbrotMengeGUI.this.malPanel.speichereBild();
            }
        });
        pnlSteuerung.add(btnSpeichern);
        JButton btnBildZuClipboard = new JButton();
        btnBildZuClipboard.setToolTipText("Bild ins Clipboard");
        btnBildZuClipboard.setIcon(new ImageIcon(MandelbrotMengeGUI.class.getResource("/mandelbrotNeu/icons/insClipboard 32x32.png")));
        btnBildZuClipboard.setPreferredSize(new Dimension(34, 34));
        btnBildZuClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MandelbrotMengeGUI.this.malPanel.copyPic();
            }
        });
        pnlSteuerung.add(btnBildZuClipboard);
        this.chckbxJuliamenge.setOpaque(false);
        this.chckbxJuliamenge.setFont(new Font("Arial", 1, 11));
        this.chckbxJuliamenge.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MandelbrotMengeGUI.this.chckbxJuliamenge.isSelected()) {
                    MandelbrotMengeGUI.this.tfItertiefe.setValue(200);
                }
            }
        });
        pnlSteuerung.add(this.chckbxJuliamenge);
        this.pnlGrafik.setPreferredSize(new Dimension(this.imgBreite + 5, this.imgHoehe + 5));
        this.pnlGrafik.setBackground(new Color(192, 192, 192));
        this.contentPane.add((Component)this.pnlGrafik, "Center");
        this.installiereMalPanel();
        JPanel pnlMenue = new JPanel();
        pnlMenue.setBackground(new Color(255, 245, 238));
        pnlMenue.setPreferredSize(new Dimension(135, 350));
        pnlMenue.setLayout(new FlowLayout(1, 2, 3));
        this.contentPane.add((Component)pnlMenue, "West");
        JPanel pnlAufloesung = new JPanel();
        pnlAufloesung.setBackground(new Color(230, 230, 250));
        pnlAufloesung.setPreferredSize(new Dimension(133, 60));
        pnlAufloesung.setBorder(new TitledBorder(null, "  Aufl\u00f6sung  ", 4, 2, null, null));
        pnlMenue.add(pnlAufloesung);
        String[] aufloesungFeld = new String[]{"17 x 15", "51 x 45", "119 x 105", "221 x 195", "323 x 285", "459 x 405", "629 x 555", "833 x 735", "1173 x 1035", "1377 x 1215"};
        this.comboBoxAufloesung.setBackground(new Color(240, 248, 255));
        this.comboBoxAufloesung.setPreferredSize(new Dimension(100, 25));
        this.comboBoxAufloesung.setFont(new Font("Arial", 1, 12));
        int i2 = 0;
        while (i2 < aufloesungFeld.length) {
            this.comboBoxAufloesung.addItem(aufloesungFeld[i2]);
            ++i2;
        }
        this.comboBoxAufloesung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MandelbrotMengeGUI.this.setzeNeueAufloesung();
            }
        });
        this.comboBoxAufloesung.setSelectedIndex(5);
        pnlAufloesung.add(this.comboBoxAufloesung);
        JPanel pnlBildbereich = new JPanel();
        pnlBildbereich.setBackground(new Color(240, 248, 255));
        pnlBildbereich.setPreferredSize(new Dimension(133, 180));
        pnlBildbereich.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "  Bildbereich  ", 4, 2, null, new Color(0, 0, 0)));
        pnlMenue.add(pnlBildbereich);
        JLabel lblxa = new JLabel("xa = ");
        lblxa.setFont(new Font("Arial", 0, 11));
        lblxa.setBounds(5, 19, 26, 25);
        lblxa.setPreferredSize(new Dimension(25, 25));
        pnlBildbereich.add(lblxa);
        this.tfxa.setFont(new Font("Arial", 0, 11));
        this.tfxa.setBounds(32, 18, 95, 25);
        this.tfxa.setPreferredSize(new Dimension(80, 25));
        pnlBildbereich.add(this.tfxa);
        JLabel lblxe = new JLabel("xe = ");
        lblxe.setPreferredSize(new Dimension(25, 25));
        lblxe.setFont(new Font("Arial", 0, 11));
        lblxe.setBounds(5, 41, 26, 18);
        pnlBildbereich.add(lblxe);
        this.tfxe.setPreferredSize(new Dimension(80, 25));
        this.tfxe.setFont(new Font("Arial", 0, 11));
        this.tfxe.setBounds(32, 40, 95, 20);
        pnlBildbereich.add(this.tfxe);
        JLabel lblya = new JLabel("ya = ");
        lblya.setPreferredSize(new Dimension(25, 25));
        lblya.setFont(new Font("Arial", 0, 11));
        lblya.setBounds(5, 65, 27, 18);
        pnlBildbereich.add(lblya);
        this.tfya.setFont(new Font("Arial", 0, 11));
        this.tfya.setPreferredSize(new Dimension(80, 25));
        this.tfya.setBounds(33, 62, 95, 20);
        pnlBildbereich.add(this.tfya);
        JLabel lblye = new JLabel("ye = ");
        lblye.setPreferredSize(new Dimension(25, 25));
        lblye.setFont(new Font("Arial", 0, 11));
        lblye.setBounds(5, 86, 27, 18);
        pnlBildbereich.add(lblye);
        this.tfye.setFont(new Font("Arial", 0, 11));
        this.tfye.setPreferredSize(new Dimension(80, 25));
        this.tfye.setBounds(32, 84, 95, 20);
        pnlBildbereich.add(this.tfye);
        JButton btn1Zu1 = new JButton("1:1");
        btn1Zu1.setPreferredSize(new Dimension(50, 25));
        btn1Zu1.setToolTipText("setzt ye so, dass dx : dy = 1:1 ");
        btn1Zu1.setFont(new Font("Arial", 1, 11));
        btn1Zu1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MandelbrotMengeGUI.this.tfye.setValue(MandelbrotMengeGUI.this.tfya.getValue() + (MandelbrotMengeGUI.this.tfxe.getValue() - MandelbrotMengeGUI.this.tfxa.getValue()) * (double)MandelbrotMengeGUI.this.imgHoehe / (double)MandelbrotMengeGUI.this.imgBreite);
            }
        });
        btn1Zu1.setBounds(70, 107, 50, 18);
        pnlBildbereich.add(btn1Zu1);
        JPanel pnlIterationstiefe = new JPanel();
        pnlIterationstiefe.setBackground(new Color(255, 240, 245));
        pnlIterationstiefe.setPreferredSize(new Dimension(133, 60));
        pnlIterationstiefe.setFont(new Font("Arial", 0, 11));
        pnlIterationstiefe.setBorder(new TitledBorder(null, "  Iterationstiefe  ", 4, 2, null, null));
        pnlMenue.add(pnlIterationstiefe);
        JLabel lblItertiefe = new JLabel("maxIt = ");
        lblItertiefe.setFont(new Font("Arial", 1, 11));
        pnlIterationstiefe.add(lblItertiefe);
        pnlIterationstiefe.add(this.tfItertiefe);
        this.tfItertiefe.setPreferredSize(new Dimension(42, 25));
        JPanel pnlJuliacxcy = new JPanel();
        pnlJuliacxcy.setBackground(new Color(204, 255, 204));
        pnlJuliacxcy.setPreferredSize(new Dimension(133, 60));
        pnlJuliacxcy.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "  Julia (cx ; cy)  ", 4, 2, null, new Color(0, 0, 0)));
        pnlMenue.add(pnlJuliacxcy);
        this.tfcxJulia.setFont(new Font("Arial", 0, 11));
        this.tfcxJulia.setToolTipText("cx");
        this.tfcxJulia.setPreferredSize(new Dimension(50, 25));
        pnlJuliacxcy.add(this.tfcxJulia);
        this.tfcyJulia.setFont(new Font("Arial", 0, 11));
        this.tfcyJulia.setToolTipText("cy");
        this.tfcyJulia.setPreferredSize(new Dimension(50, 25));
        pnlJuliacxcy.add(this.tfcyJulia);
        JPanel pnlInfos = new JPanel();
        pnlInfos.setBackground(new Color(245, 245, 220));
        pnlInfos.setPreferredSize(new Dimension(133, 165));
        pnlInfos.setBorder(new TitledBorder(null, "  Infos  ", 4, 2, null, null));
        pnlMenue.add(pnlInfos);
        pnlInfos.setLayout(new GridLayout(0, 1, 0, 0));
        this.lblRechenzeit.setForeground(new Color(30, 144, 255));
        this.lblRechenzeit.setPreferredSize(new Dimension(57, 10));
        this.lblRechenzeit.setFont(new Font("Arial", 0, 11));
        pnlInfos.add(this.lblRechenzeit);
        this.lblSymmetrie.setForeground(new Color(32, 178, 170));
        this.lblSymmetrie.setFont(new Font("Arial", 0, 11));
        pnlInfos.add(this.lblSymmetrie);
        this.lblAufloesung.setForeground(new Color(0, 139, 139));
        this.lblAufloesung.setFont(new Font("Arial", 0, 11));
        pnlInfos.add(this.lblAufloesung);
        JLabel lblSchwarzePixels_0 = new JLabel("schwarze Pixels:");
        lblSchwarzePixels_0.setForeground(new Color(128, 0, 128));
        lblSchwarzePixels_0.setFont(new Font("Arial", 0, 11));
        pnlInfos.add(lblSchwarzePixels_0);
        this.lblSchwarzePixels.setForeground(new Color(128, 0, 128));
        this.lblSchwarzePixels.setFont(new Font("Arial", 1, 10));
        pnlInfos.add(this.lblSchwarzePixels);
        this.lblFlaeche.setForeground(new Color(143, 188, 143));
        this.lblFlaeche.setToolTipText("Fl\u00e4che gesch\u00e4tzt per Pixelz\u00e4hlung ");
        this.lblFlaeche.setFont(new Font("Arial", 0, 11));
        pnlInfos.add(this.lblFlaeche);
        this.lblMausposition.setFont(new Font("Arial", 0, 10));
        pnlInfos.add(this.lblMausposition);
    }

    void installiereMalPanel() {
        this.malPanel = new MeineLeinwand(this.imgBreite, this.imgHoehe);
        this.malPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                MandelbrotMengeGUI.this.lblMausposition.setText("Maus: (" + String.valueOf(MandelbrotMengeGUI.this.rundeString(MandelbrotMengeGUI.this.xUser(me.getX()), 4)) + " | " + String.valueOf(MandelbrotMengeGUI.this.rundeString(MandelbrotMengeGUI.this.yUser(me.getY()), 4)) + ")");
            }
        });
        this.malPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!MandelbrotMengeGUI.this.chckbxGenauer.isSelected() && MandelbrotMengeGUI.this.malPanel.zoomOK) {
                    MandelbrotMengeGUI.this.setzeZoomWerte();
                }
            }
        });
        this.malPanel.setPreferredSize(new Dimension(this.imgBreite, this.imgHoehe));
        this.malPanel.setLayout(new FlowLayout(1, 5, 5));
        this.pnlGrafik.add(this.malPanel);
    }

    void setzeNeueAufloesung() {
        switch (this.comboBoxAufloesung.getSelectedIndex()) {
            case 0: {
                this.imgHoehe = 15;
                break;
            }
            case 1: {
                this.imgHoehe = 45;
                break;
            }
            case 2: {
                this.imgHoehe = 105;
                break;
            }
            case 3: {
                this.imgHoehe = 195;
                break;
            }
            case 4: {
                this.imgHoehe = 285;
                break;
            }
            case 5: {
                this.imgHoehe = 405;
                break;
            }
            case 6: {
                this.imgHoehe = 555;
                break;
            }
            case 7: {
                this.imgHoehe = 735;
                break;
            }
            case 8: {
                this.imgHoehe = 1035;
                break;
            }
            case 9: {
                this.imgHoehe = 1215;
            }
        }
        this.imgBreite = this.imgHoehe * 17 / 15;
        this.lblAufloesung.setText("Aufl\u00f6sung: " + this.imgBreite + this.sMAL + this.imgHoehe);
        this.malPanel.removeBuffer();
        this.pnlGrafik.remove(this.malPanel);
        this.installiereMalPanel();
        if (this.comboBoxAufloesung.getSelectedIndex() > 5) {
            this.setSize(this.imgBreite + 180, this.imgHoehe + 105);
        } else {
            this.repaint();
            this.setSize(628, 640);
        }
        this.setLocationRelativeTo(null);
    }

    public String rundeString(double x, int nk) {
        String s = "0.0";
        int i = 1;
        while (i < nk) {
            s = String.valueOf(s) + "0";
            ++i;
        }
        DecimalFormat df = new DecimalFormat(s);
        return df.format(x);
    }

    public double xUser(int xPix) {
        return this.tfxa.getValue() + (double)xPix * (this.tfxe.getValue() - this.tfxa.getValue()) / (double)(this.imgBreite - 1);
    }

    public double yUser(int yPix) {
        return this.tfye.getValue() - (double)yPix * (this.tfye.getValue() - this.tfya.getValue()) / (double)(this.imgHoehe - 1);
    }

    public void zeichneAchsen() {
        this.malPanel.zeichneAchsen(this.tfxa.getValue(), this.tfxe.getValue(), this.tfya.getValue(), this.tfye.getValue(), Color.RED);
    }

    void setzeZoomWerte() {
        if (this.malPanel.zoomOK) {
            double xa = this.xUser(this.malPanel.xZ1);
            double xe = this.xUser(this.malPanel.xZ2);
            double ya = this.yUser(this.malPanel.yZ2);
            double ye = this.yUser(this.malPanel.yZ1);
            this.tfxa.setText(this.rundeString(xa, 6));
            this.tfxe.setText(this.rundeString(xe, 6));
            this.tfya.setText(this.rundeString(ya, 6));
            this.tfye.setText(this.rundeString(ye, 6));
            this.malPanel.zoomOK = false;
        }
    }

    public void setzeStandardBildbereich() {
        this.tfxa.setText("-2.02");
        this.tfxe.setText("0.7");
        this.tfya.setText("-1.2");
        this.tfye.setText("1.2");
    }

    public void resetWerte() {
        if (this.chckbxJuliamenge.isSelected()) {
            this.tfxa.setText("-1.6");
            this.tfxe.setText("1.6");
            this.tfya.setText("-1.2");
            this.tfye.setText("1.2");
            this.tfcxJulia.setText("-0.777");
            this.tfcyJulia.setText("0.116");
            this.tfItertiefe.setValue(200);
        } else {
            this.setzeStandardBildbereich();
            this.tfItertiefe.setValue(500);
        }
        this.comboBoxHochgenau.setSelectedIndex(1);
        this.abtastRate = 32;
        this.chckbxGenauer.setSelected(false);
        this.chckbxFarbig.setSelected(false);
    }

    public void zeichneJuliamenge() {
        double cx = this.tfcxJulia.getValue();
        double cy = this.tfcyJulia.getValue();
        double xa = this.tfxa.getValue();
        double xe = this.tfxe.getValue();
        double ya = this.tfya.getValue();
        double ye = this.tfye.getValue();
        double dx = (xe - xa) / (double)(this.imgBreite - 1);
        double dy = (ye - ya) / (double)(this.imgHoehe - 1);
        int maxIt = this.tfItertiefe.getValue();
        this.malPanel.clearBufImg();
        Color pixFarbe = Color.BLACK;
        int sp = 0;
        while (sp < this.imgBreite) {
            int ze = 0;
            while (ze < this.imgHoehe) {
                double tmp;
                double zx = xa + (double)sp * dx;
                double zy = ye - (double)ze * dy;
                int zaehler = 0;
                while ((zx = (tmp = zx * zx - zy * zy + cx)) * zx + (zy = 2.0 * zx * zy + cy) * zy <= 4.0 && ++zaehler < maxIt) {
                }
                if (zaehler == maxIt) {
                    this.malPanel.zeichnePixel(sp, ze, pixFarbe);
                }
                ++ze;
            }
            ++sp;
        }
    }

    public void bestimmeSymmetriefall() {
        boolean xAchse_im_Bild;
        boolean istSymmetrisch = Math.abs(this.tfya.getValue() + this.tfye.getValue()) < 1.0E-10;
        boolean bl = xAchse_im_Bild = this.tfya.getValue() * this.tfye.getValue() <= 0.0;
        if (this.chckbxGenauer.isSelected()) {
            this.setzeStandardBildbereich();
            this.symmetrieFall = "Symmetrie; hochgenau";
            if (this.comboBoxHochgenau.getSelectedIndex() == this.comboBoxHochgenau.getItemCount() - 1) {
                this.symmetrieFall = "Schwarz; x-AchsensymmetrieBD";
            }
        } else {
            this.symmetrieFall = !this.chckbxFarbig.isSelected() ? (istSymmetrisch ? "Schwarz; x-Achsensymmetrie" : (xAchse_im_Bild ? "Schwarz; mit beliebiger xAchse" : "Schwarz; keine xAchse")) : (istSymmetrisch ? "Farbe; x-Achsensymmetrie" : (xAchse_im_Bild ? "Farbe; mit beliebiger xAchse" : "Farbe; keine xAchse"));
        }
        if (istSymmetrisch) {
            this.lblSymmetrie.setText("Symmetrie: x-Achse");
        } else {
            this.lblSymmetrie.setText("Symmetrie: keine");
        }
    }

    void zeichneMandelbrotmenge() {
        int maxIt = this.tfItertiefe.getValue();
        double xa = this.tfxa.getValue();
        double xe = this.tfxe.getValue();
        double ya = this.tfya.getValue();
        double ye = this.tfye.getValue();
        double dx = (xe - xa) / (double)(this.imgBreite - 1);
        double dy = (ye - ya) / (double)(this.imgHoehe - 1);
        int yHalbe = this.imgHoehe / 2;
        int y0Pkt = (int)(ye / (ye - ya) * (double)(this.imgHoehe - 1));
        Color pixFarbe = Color.BLACK;
        Color[] farbFeld = new Color[]{Color.WHITE, Color.YELLOW, Color.PINK, Color.GREEN, Color.CYAN, Color.LIGHT_GRAY, Color.RED, Color.ORANGE, Color.GRAY, Color.BLUE, Color.DARK_GRAY, Color.MAGENTA};
        this.bestimmeSymmetriefall();
        this.malPanel.clearBufImg();
        long zeit = System.currentTimeMillis();
        switch (this.symmetrieFall) {
            case "Schwarz; x-Achsensymmetrie": {
                int sp = 0;
                while (sp < this.imgBreite) {
                    double cx = xa + (double)sp * dx;
                    int ze = yHalbe + 1;
                    while (ze < this.imgHoehe) {
                        double cy = ye - (double)ze * dy;
                        if (this.iterZahl(cx, cy) == maxIt) {
                            this.malPanel.zeichnePixel(sp, ze, pixFarbe);
                            this.malPanel.zeichnePixel(sp, this.imgHoehe - 1 - ze, pixFarbe);
                        }
                        ++ze;
                    }
                    if (this.iterZahl(cx, 0.0) == maxIt) {
                        this.malPanel.zeichnePixel(sp, yHalbe, pixFarbe);
                    }
                    ++sp;
                }
                break;
            }
            case "Schwarz; mit beliebiger xAchse": {
                double cx = xa;
                int sp = 0;
                while (sp < this.imgBreite) {
                    double cy = 0.0;
                    int ze = y0Pkt;
                    while (ze < this.imgHoehe) {
                        if (this.iterZahl(cx, cy) == maxIt) {
                            this.malPanel.zeichnePixel(sp, ze, pixFarbe);
                        }
                        cy -= dy;
                        ++ze;
                    }
                    cy = 0.0;
                    ze = y0Pkt;
                    while (ze >= 0) {
                        if (this.iterZahl(cx, cy) == maxIt) {
                            this.malPanel.zeichnePixel(sp, ze, pixFarbe);
                        }
                        cy += dy;
                        --ze;
                    }
                    cx += dx;
                    ++sp;
                }
                break;
            }
            case "Schwarz; keine xAchse": {
                int sp = 0;
                while (sp < this.imgBreite) {
                    double cx = xa + (double)sp * dx;
                    int ze = 0;
                    while (ze < this.imgHoehe) {
                        double cy = ye - (double)ze * dy;
                        if (this.iterZahl(cx, cy) == maxIt) {
                            this.malPanel.zeichnePixel(sp, ze, pixFarbe);
                        }
                        ++ze;
                    }
                    ++sp;
                }
                break;
            }
            case "Farbe; x-Achsensymmetrie": {
                int sp = 0;
                while (sp < this.imgBreite) {
                    int zaehler;
                    double cx = xa + (double)sp * dx;
                    int ze = yHalbe + 1;
                    while (ze < this.imgHoehe) {
                        double cy = ye - (double)ze * dy;
                        zaehler = this.iterZahl(cx, cy);
                        if (zaehler == maxIt) {
                            this.malPanel.zeichnePixel(sp, ze, pixFarbe);
                            this.malPanel.zeichnePixel(sp, this.imgHoehe - 1 - ze, pixFarbe);
                        } else {
                            this.malPanel.zeichnePixel(sp, ze, farbFeld[zaehler % farbFeld.length]);
                            this.malPanel.zeichnePixel(sp, this.imgHoehe - 1 - ze, farbFeld[zaehler % farbFeld.length]);
                        }
                        ++ze;
                    }
                    zaehler = this.iterZahl(cx, 0.0);
                    if (zaehler == maxIt) {
                        this.malPanel.zeichnePixel(sp, yHalbe, pixFarbe);
                    } else {
                        this.malPanel.zeichnePixel(sp, yHalbe, farbFeld[zaehler % farbFeld.length]);
                    }
                    ++sp;
                }
                break;
            }
            case "Farbe; mit beliebiger xAchse": {
                double cx = xa;
                int sp = 0;
                while (sp < this.imgBreite) {
                    int zaehler;
                    double cy = 0.0;
                    int ze = y0Pkt;
                    while (ze < this.imgHoehe) {
                        zaehler = this.iterZahl(cx, cy);
                        if (zaehler == maxIt) {
                            this.malPanel.zeichnePixel(sp, ze, pixFarbe);
                        } else if (zaehler >= 4 && zaehler <= 32) {
                            this.malPanel.zeichnePixel(sp, ze, farbFeld[zaehler % farbFeld.length]);
                        }
                        cy -= dy;
                        ++ze;
                    }
                    cy = 0.0;
                    ze = y0Pkt;
                    while (ze >= 0) {
                        zaehler = this.iterZahl(cx, cy);
                        if (zaehler == maxIt) {
                            this.malPanel.zeichnePixel(sp, ze, pixFarbe);
                        } else {
                            this.malPanel.zeichnePixel(sp, ze, farbFeld[zaehler % farbFeld.length]);
                        }
                        cy += dy;
                        --ze;
                    }
                    cx += dx;
                    ++sp;
                }
                break;
            }
            case "Farbe; keine xAchse": {
                int sp = 0;
                while (sp < this.imgBreite) {
                    double cx = xa + (double)sp * dx;
                    int ze = 0;
                    while (ze < this.imgHoehe) {
                        double cy = ye - (double)ze * dy;
                        int zaehler = this.iterZahl(cx, cy);
                        if (zaehler == maxIt) {
                            this.malPanel.zeichnePixel(sp, ze, pixFarbe);
                        } else {
                            this.malPanel.zeichnePixel(sp, ze, farbFeld[zaehler % farbFeld.length]);
                        }
                        ++ze;
                    }
                    ++sp;
                }
                break;
            }
            case "Symmetrie; hochgenau": {
                int mul = this.abtastRate + 1;
                int mul2 = mul / 2;
                double dxmul = dx / (double)mul;
                double dymul = dy / (double)mul;
                double cx = xa;
                int sp = 0;
                while (sp < this.imgBreite) {
                    double cxTmp = cx;
                    int j = -mul2;
                    while (j < mul2) {
                        cxTmp = cx + (double)j * dxmul;
                        double cy = 0.0;
                        int ze = yHalbe;
                        while (ze < this.imgHoehe) {
                            double cyTmp = cy;
                            int k = -mul2;
                            while (k < mul2) {
                                cyTmp = cy - (double)k * dymul;
                                if (this.iterZahl(cxTmp, cyTmp) == maxIt) {
                                    this.malPanel.zeichnePixel(sp, ze, pixFarbe);
                                    this.malPanel.zeichnePixel(sp, this.imgHoehe - 1 - ze, pixFarbe);
                                }
                                ++k;
                            }
                            cy -= dy;
                            ++ze;
                        }
                        ++j;
                    }
                    cx += dx;
                    this.malPanel.zeigeBufImg();
                    ++sp;
                }
                break;
            }
            case "Schwarz; x-AchsensymmetrieBD": {
                BigDecimal yeBigDec = BigDecimal.valueOf(ye);
                BigDecimal cxBigDec = BigDecimal.valueOf(xa);
                BigDecimal cyBigDec = yeBigDec;
                BigDecimal dxBigDec = BigDecimal.valueOf(dx);
                BigDecimal dyBigDec = BigDecimal.valueOf(dy);
                int sp = 0;
                while (sp < this.imgBreite) {
                    cyBigDec = yeBigDec;
                    int ze = 0;
                    while (ze < yHalbe) {
                        if (this.iterZahlBigDec(cxBigDec, cyBigDec) == maxIt) {
                            this.malPanel.zeichnePixel(sp, ze, pixFarbe);
                            this.malPanel.zeichnePixel(sp, this.imgHoehe - 1 - ze, pixFarbe);
                        }
                        cyBigDec = cyBigDec.subtract(dyBigDec, mContext);
                        ++ze;
                    }
                    cyBigDec = BigDecimal.ZERO;
                    if (this.iterZahlBigDec(cxBigDec, cyBigDec) == maxIt) {
                        this.malPanel.zeichnePixel(sp, yHalbe, pixFarbe);
                    }
                    cxBigDec = cxBigDec.add(dxBigDec, mContext);
                    this.malPanel.zeigeBufImg();
                    ++sp;
                }
                break;
            }
        }
        zeit = System.currentTimeMillis() - zeit;
        this.lblRechenzeit.setText(String.valueOf(this.rundeString((double)zeit / 1000.0, 3)) + " s ben\u00f6tigt");
        int pixelsGesamt = this.imgBreite * this.imgHoehe;
        int pixelsSchwarz = this.malPanel.anzahlPixels(Color.BLACK);
        this.lblSchwarzePixels.setText(String.valueOf(pixelsSchwarz) + " von " + pixelsGesamt);
        double flaecheRahmen = (this.tfxe.getValue() - this.tfxa.getValue()) * (this.tfye.getValue() - this.tfya.getValue());
        double flaecheMandelbrot = flaecheRahmen * (double)pixelsSchwarz / (double)pixelsGesamt;
        this.lblFlaeche.setText("Fl\u00e4che: " + this.rundeString(flaecheMandelbrot, 4));
    }

    public int iterZahl(double cx, double cy) {
        double s;
        double r;
        int maxIt = this.tfItertiefe.getValue();
        int count = 0;
        double zx = 0.0;
        double zy = 0.0;
        double zxq = 0.0;
        double zyq = 0.0;
        double cyq = cy * cy;
        if (cx > -0.75 ? 16.0 * (r = cx * cx + cyq) * (s = Math.sqrt(r - 0.5 * cx + 0.0625)) <= 5.0 * s - 4.0 * cx + 1.0 : cx >= -1.25 && (cx + 1.0) * (cx + 1.0) + cyq <= 0.0625) {
            return maxIt;
        }
        while ((zxq = (zx = zxq - zyq + cx) * zx) + (zyq = (zy = 2.0 * zx * zy + cy) * zy) <= 4.0 && ++count < maxIt) {
        }
        return count;
    }

    static BigDecimal quad(BigDecimal x) {
        return x.multiply(x, mContext);
    }

    public int iterZahlBigDec(BigDecimal cxBD, BigDecimal cyBD) {
        int maxIt = this.tfItertiefe.getValue();
        int count = 0;
        BigDecimal zx = BigDecimal.ZERO;
        BigDecimal zy = BigDecimal.ZERO;
        BigDecimal zxq = BigDecimal.ZERO;
        BigDecimal zyq = BigDecimal.ZERO;
        BigDecimal cyqBD = MandelbrotMengeGUI.quad(cyBD);
        if (cxBD.compareTo(BigDecimal.valueOf(-0.75)) == 1) {
            BigDecimal reS;
            BigDecimal rBD = MandelbrotMengeGUI.quad(cxBD).add(cyqBD, mContext);
            BigDecimal sBD = rBD.subtract(cxBD.divide(new BigDecimal("2"), mContext), mContext).add(BigDecimal.valueOf(0.0625), mContext).sqrt(mContext);
            BigDecimal liS = BigDecimal.valueOf(16.0).multiply(rBD, mContext).multiply(sBD, mContext);
            if (liS.compareTo(reS = BigDecimal.valueOf(5.0).multiply(sBD, mContext).subtract(BigDecimal.valueOf(4.0).multiply(cxBD, mContext), mContext).add(new BigDecimal("1"), mContext)) < 1) {
                return maxIt;
            }
        } else if (cxBD.compareTo(BigDecimal.valueOf(-1.25)) >= 0 && MandelbrotMengeGUI.quad(cxBD.add(BigDecimal.ONE, mContext)).add(cyqBD, mContext).compareTo(BigDecimal.valueOf(0.0625)) < 1) {
            return maxIt;
        }
        do {
            zy = zx.multiply(zy, mContext).multiply(new BigDecimal("2"), mContext).add(cyBD, mContext);
        } while ((zxq = MandelbrotMengeGUI.quad(zx = zxq.subtract(zyq, mContext).add(cxBD, mContext))).add(zyq = MandelbrotMengeGUI.quad(zy), mContext).compareTo(BigDecimal.valueOf(4.0)) < 1 && ++count < maxIt);
        return count;
    }
}

