/*
 * Decompiled with CFR 0.152.
 */
package mandelbrotNeu;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mandelbrotNeu.ImageTransferable;

class MeineLeinwand
extends JPanel {
    private static final long serialVersionUID = 7074019781860606935L;
    private int breiteBuf;
    private int hoeheBuf;
    private Cursor cursorZoom;
    private BufferedImage bufImg;
    private Graphics2D grBufImg;
    private BufferedImage bufZoom;
    private Graphics2D grBufZoom;
    private BufferedImage bufKopie;
    private Graphics2D grBufKopie;
    public LinienArt linienArt = LinienArt.SOLID;
    float[] dash = new float[]{5.0f, 2.0f};
    float[] dot = new float[]{1.0f, 2.0f};
    float[] dash_dot = new float[]{6.0f, 3.0f, 2.0f, 3.0f};
    boolean zoomOK = false;
    public int xZ1 = 0;
    public int yZ1 = 0;
    public int xZ2;
    public int yZ2;

    public MeineLeinwand(int breite, int hoehe) {
        this.breiteBuf = breite;
        this.hoeheBuf = hoehe;
        this.addMouseListener(new MeinMausListener());
        this.addMouseMotionListener(new MeinMausMotionListener());
        this.erzeugeNeueCursoren();
        this.initBuffer();
    }

    @Override
    public void paintComponent(Graphics grPnl) {
        Graphics2D g2d = (Graphics2D)grPnl;
        super.paintComponent(g2d);
        g2d.drawImage((Image)this.bufImg, 0, 0, this);
        this.repaint();
    }

    public void initBuffer() {
        this.bufImg = new BufferedImage(this.breiteBuf, this.hoeheBuf, 1);
        this.grBufImg = this.bufImg.createGraphics();
        this.grBufImg.setBackground(Color.WHITE);
        this.clearBufImg();
        this.grBufImg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.grBufImg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public void removeBuffer() {
        this.grBufImg.dispose();
    }

    public void clearBufImg() {
        this.grBufImg.clearRect(0, 0, this.breiteBuf, this.hoeheBuf);
    }

    public void macheBufKopie() {
        this.bufKopie = new BufferedImage(this.breiteBuf, this.hoeheBuf, 1);
        this.grBufKopie = this.bufKopie.createGraphics();
        this.grBufKopie.drawImage((Image)this.bufImg, 0, 0, this);
    }

    public void holeBufKopie() {
        this.grBufImg.drawImage((Image)this.bufKopie, 0, 0, this);
    }

    public void zeigeBufImg() {
        this.getGraphics().drawImage(this.bufImg, 0, 0, this);
    }

    public Image loadImage(String path) {
        return new ImageIcon(this.getClass().getResource(path)).getImage();
    }

    void erzeugeNeueCursoren() {
        Image zoomImg = this.loadImage("cursors/cursorZoom 15;20.png");
        this.cursorZoom = this.getToolkit().createCustomCursor(zoomImg, new Point(15, 20), "Zoom");
    }

    public int anzahlPixels(Color farbe) {
        int zaehler = 0;
        int sp = 0;
        while (sp < this.breiteBuf) {
            int ze = 0;
            while (ze < this.hoeheBuf) {
                if (this.bufImg.getRGB(sp, ze) == farbe.getRGB()) {
                    ++zaehler;
                }
                ++ze;
            }
            ++sp;
        }
        return zaehler;
    }

    public void zeichnePixel(int sp, int ze, Color farbe) {
        this.bufImg.setRGB(sp, ze, farbe.getRGB());
    }

    public void zeichnePixelRGB(int sp, int ze, int farbeRGB) {
        this.bufImg.setRGB(sp, ze, farbeRGB);
    }

    public void setzeLinienStil(float dicke, LinienArt pen) {
        switch (pen) {
            case SOLID: {
                this.grBufImg.setStroke(new BasicStroke(dicke, 1, 1));
                break;
            }
            case DASH: {
                this.grBufImg.setStroke(new BasicStroke(dicke, 0, 1, 1.0f, this.dash, 0.0f));
                break;
            }
            case DOT: {
                this.grBufImg.setStroke(new BasicStroke(dicke, 0, 1, 1.0f, this.dot, 0.0f));
                break;
            }
            case DASH_DOT: {
                this.grBufImg.setStroke(new BasicStroke(dicke, 0, 1, 1.0f, this.dash_dot, 0.0f));
            }
        }
    }

    public void zeichneLinie2D(int x1, int y1, int x2, int y2, float dicke, LinienArt pen, Color col) {
        this.setzeLinienStil(dicke, pen);
        Line2D.Double linie2d = new Line2D.Double(x1, y1, x2, y2);
        this.grBufImg.setColor(col);
        this.grBufImg.draw(linie2d);
    }

    public void zeichneRechteck2DPix(int x1, int y1, int x2, int y2, float dicke, LinienArt pen, Color col, boolean fill) {
        this.setzeLinienStil(dicke, pen);
        Rectangle2D.Double recht2d = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
        if (fill) {
            this.grBufImg.fill(recht2d);
        }
        this.grBufImg.setColor(col);
        this.grBufImg.draw(recht2d);
    }

    public void schreibeText(String text, int xpos, int ypos, Font fontTxt, Color farbe) {
        this.grBufImg.setFont(fontTxt);
        this.grBufImg.setColor(farbe);
        this.grBufImg.drawString(text, xpos, ypos);
    }

    public int xPix(double xUser, double xa, double xe) {
        return (int)Math.rint((xUser - xa) / (xe - xa) * (double)(this.breiteBuf - 1));
    }

    public int yPix(double yUser, double ya, double ye) {
        return (int)Math.rint((ye - yUser) / (ye - ya) * (double)(this.hoeheBuf - 1));
    }

    public void zeichneAchsen(double xa, double xe, double ya, double ye, Color col) {
        this.grBufImg.setColor(col);
        this.grBufImg.drawLine(this.xPix(xa, xa, xe), this.yPix(0.0, ya, ye), this.xPix(xe, xa, xe), this.yPix(0.0, ya, ye));
        this.grBufImg.drawLine(this.xPix(0.0, xa, xe), this.yPix(ya, ya, ye), this.xPix(0.0, xa, xe), this.yPix(ye, ya, ye));
    }

    public void copyPic() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ImageTransferable selection = new ImageTransferable(this.bufImg);
        clipboard.setContents(selection, null);
    }

    public void pastePic() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
            try {
                BufferedImage bufTmp = (BufferedImage)clipboard.getData(DataFlavor.imageFlavor);
                this.grBufImg.drawImage((Image)bufTmp, 0, 0, null);
            }
            catch (UnsupportedFlavorException exception) {
                JOptionPane.showMessageDialog(null, exception);
            }
            catch (IOException exception) {
                JOptionPane.showMessageDialog(null, exception);
            }
        }
    }

    public void ladeBild() {
        JFrame dateiDialogFrame = new JFrame();
        String bildDateiListe = "*.jpg;*.bmp;*.gif;*.png";
        try {
            FileDialog d = new FileDialog((Frame)dateiDialogFrame, "Bild laden", 0);
            d.setFile(bildDateiListe);
            d.setVisible(true);
            if (d.getFile() == null) {
                return;
            }
            String pfadName = String.valueOf(d.getDirectory()) + d.getFile();
            File bildDatei = new File(pfadName);
            BufferedImage bufTmp = ImageIO.read(bildDatei);
            this.grBufImg.drawImage((Image)bufTmp, 0, 0, null);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Fehler beim \u00d6ffnen der Datei!");
        }
    }

    public void speichereBild() {
        JFrame speicherFrame = new JFrame();
        try {
            FileDialog d = new FileDialog((Frame)speicherFrame, "Bild speichern: (Extension ist .png)", 1);
            d.setVisible(true);
            if (d.getFile() == null) {
                return;
            }
            String dateiName = String.valueOf(d.getDirectory()) + d.getFile();
            if (!dateiName.toLowerCase().endsWith(".png")) {
                dateiName = String.valueOf(dateiName) + ".png";
            }
            ImageIO.write((RenderedImage)this.bufImg, "png", new File(dateiName));
            JOptionPane.showMessageDialog(null, "Bild gespeichert");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum LinienArt {
        SOLID,
        DASH,
        DOT,
        DASH_DOT;

    }

    class MeinMausListener
    extends MouseAdapter {
        MeinMausListener() {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            MeineLeinwand.this.setCursor(MeineLeinwand.this.cursorZoom);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            MeineLeinwand.this.xZ1 = me.getX();
            MeineLeinwand.this.yZ1 = me.getY();
            MeineLeinwand.this.xZ2 = MeineLeinwand.this.xZ1;
            MeineLeinwand.this.yZ2 = MeineLeinwand.this.yZ1;
            MeineLeinwand.this.bufZoom = new BufferedImage(MeineLeinwand.this.breiteBuf, MeineLeinwand.this.hoeheBuf, 1);
            MeineLeinwand.this.grBufZoom = MeineLeinwand.this.bufZoom.createGraphics();
            MeineLeinwand.this.grBufZoom.drawImage((Image)MeineLeinwand.this.bufImg, 0, 0, null);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            MeineLeinwand.this.grBufImg.drawImage((Image)MeineLeinwand.this.bufZoom, 0, 0, null);
            MeineLeinwand.this.grBufZoom.dispose();
            MeineLeinwand.this.zoomOK = MeineLeinwand.this.xZ1 < MeineLeinwand.this.xZ2 && MeineLeinwand.this.yZ1 < MeineLeinwand.this.yZ2;
        }

        @Override
        public void mouseExited(MouseEvent me) {
            MeineLeinwand.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class MeinMausMotionListener
    extends MouseMotionAdapter {
        MeinMausMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            MeineLeinwand.this.xZ2 = me.getX();
            MeineLeinwand.this.yZ2 = me.getY();
            MeineLeinwand.this.grBufImg.drawImage((Image)MeineLeinwand.this.bufZoom, 0, 0, null);
            MeineLeinwand.this.zeichneRechteck2DPix(MeineLeinwand.this.xZ1, MeineLeinwand.this.yZ1, MeineLeinwand.this.xZ2, MeineLeinwand.this.yZ2, 1.0f, LinienArt.DASH, Color.RED, false);
        }

        @Override
        public void mouseMoved(MouseEvent me) {
        }
    }
}

