/*
 * Decompiled with CFR 0.152.
 */
package textFelderTools;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class MeinDoubleTextFeld
extends JTextField {
    private static final long serialVersionUID = 1L;
    private final String zeichenmengeDouble = "0123456789,.-eE/piw";
    private double wert;
    private String kette = "0,0";
    private double xVon = -1.7976931348623157E308;
    private double xBis = Double.MAX_VALUE;

    public MeinDoubleTextFeld() {
        super.setText(this.kette);
        super.setBorder(new LineBorder(new Color(171, 173, 179), 2, true));
        this.wert = 0.0;
        this.addFocusListener(new MeinFocusAdapter());
        this.addKeyListener(new MeinKeyAdapter());
    }

    public MeinDoubleTextFeld(String s) {
        this();
        this.setText(s);
    }

    public MeinDoubleTextFeld(String s, String sVon, String sBis) {
        this(s);
        this.xVon = Double.parseDouble(sVon.replace(',', '.'));
        this.xBis = Double.parseDouble(sBis.replace(',', '.'));
    }

    public double getValue() {
        return this.wert;
    }

    public void setValue(double wert) {
        this.wert = wert;
        this.kette = Double.toString(wert).replace(".", ",");
        super.setText(this.kette);
    }

    public long[] sBruchZuLongBruch(String s) {
        long zaehler = 0L;
        long nenner = 0L;
        long errCode = 0L;
        s = s.trim().replace(" ", "");
        String[] feld = new String[]{"", ""};
        if (s.indexOf(47) > 0 && ((feld = s.split("/"))[0].indexOf(47) >= 0 || feld[1].indexOf(47) >= 0)) {
            long[] lArray = new long[3];
            lArray[2] = 1L;
            return lArray;
        }
        try {
            zaehler = Long.parseLong(feld[0]);
            nenner = Long.parseLong(feld[1]);
            if (nenner < 0L) {
                nenner = -nenner;
                zaehler = -zaehler;
            }
        }
        catch (NumberFormatException ex) {
            errCode = 1L;
        }
        return new long[]{zaehler, nenner, errCode};
    }

    @Override
    public void setText(String kette) {
        try {
            this.kette = kette;
            super.setText(kette);
            if (kette.equals("pi")) {
                this.wert = Math.PI;
            } else if (kette.equals("-pi")) {
                this.wert = -Math.PI;
            } else if (kette.startsWith("pi/") || kette.startsWith("-pi/")) {
                String sDivisor = kette.substring(kette.indexOf(47) + 1).replace(",", ".");
                this.wert = Math.PI / Double.parseDouble(sDivisor);
                if (kette.charAt(0) == '-') {
                    this.wert = -this.wert;
                }
            } else if (kette.endsWith("pi")) {
                String sFaktor = kette.substring(0, kette.indexOf(112)).replace(",", ".");
                this.wert = Math.PI * Double.parseDouble(sFaktor);
            } else if (kette.startsWith("w") || kette.startsWith("-w")) {
                String sRadikand = kette.substring(kette.indexOf(119) + 1).replace(",", ".");
                this.wert = Math.sqrt(Double.parseDouble(sRadikand));
                if (kette.charAt(0) == '-') {
                    this.wert = -this.wert;
                }
            } else if (kette.indexOf(47) > 0) {
                long[] bruch = this.sBruchZuLongBruch(kette);
                System.out.println(String.valueOf(bruch[0]) + "  " + bruch[1] + "  " + bruch[2]);
                if (bruch[2] == 1L) {
                    this.setText("0.0");
                } else {
                    this.wert = 1.0 * (double)bruch[0] / (double)bruch[1];
                }
            } else {
                this.wert = Double.parseDouble(kette.replace(",", "."));
            }
        }
        catch (NumberFormatException ex) {
            this.wert = 0.0;
            this.kette = "0,0";
            super.setText(this.kette);
        }
    }

    boolean bereichUeberschritten(double x, double xVon, double xBis) {
        return x < xVon || x > xBis;
    }

    class MeinFocusAdapter
    extends FocusAdapter {
        MeinFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            MeinDoubleTextFeld.this.selectAll();
        }

        @Override
        public void focusLost(FocusEvent evt) {
            try {
                String ket0 = MeinDoubleTextFeld.this.getText();
                if (ket0.equals("pi")) {
                    MeinDoubleTextFeld.this.wert = Math.PI;
                } else if (ket0.equals("-pi")) {
                    MeinDoubleTextFeld.this.wert = -Math.PI;
                } else if (ket0.startsWith("pi/") || ket0.startsWith("-pi/")) {
                    String sDivisor = ket0.substring(ket0.indexOf(47) + 1).replace(",", ".");
                    MeinDoubleTextFeld.this.wert = Math.PI / Double.parseDouble(sDivisor);
                    if (ket0.charAt(0) == '-') {
                        MeinDoubleTextFeld.this.wert = -MeinDoubleTextFeld.this.wert;
                    }
                } else if (ket0.endsWith("pi")) {
                    String sFaktor = ket0.substring(0, ket0.indexOf(112)).replace(",", ".");
                    MeinDoubleTextFeld.this.wert = Math.PI * Double.parseDouble(sFaktor);
                } else if (ket0.startsWith("w") || ket0.startsWith("-w")) {
                    String sRadikand = ket0.substring(ket0.indexOf(119) + 1).replace(",", ".");
                    MeinDoubleTextFeld.this.wert = Math.sqrt(Double.parseDouble(sRadikand));
                    if (ket0.charAt(0) == '-') {
                        MeinDoubleTextFeld.this.wert = -MeinDoubleTextFeld.this.wert;
                    }
                } else if (ket0.indexOf(47) > 0) {
                    long[] bruch = MeinDoubleTextFeld.this.sBruchZuLongBruch(ket0);
                    System.out.println(String.valueOf(bruch[0]) + "  " + bruch[1] + "  " + bruch[2]);
                    if (bruch[2] == 1L) {
                        MeinDoubleTextFeld.this.setText(ket0);
                        MeinDoubleTextFeld.this.requestFocus();
                    } else {
                        MeinDoubleTextFeld.this.wert = 1.0 * (double)bruch[0] / (double)bruch[1];
                    }
                } else {
                    MeinDoubleTextFeld.this.wert = Double.parseDouble(ket0.replace(",", "."));
                }
                System.out.println(MeinDoubleTextFeld.this.wert);
                if (!Double.isFinite(MeinDoubleTextFeld.this.wert)) {
                    MeinDoubleTextFeld.this.setText(String.valueOf(MeinDoubleTextFeld.this.wert));
                    MeinDoubleTextFeld.this.requestFocus();
                } else if (MeinDoubleTextFeld.this.bereichUeberschritten(MeinDoubleTextFeld.this.wert, MeinDoubleTextFeld.this.xVon, MeinDoubleTextFeld.this.xBis)) {
                    JOptionPane.showMessageDialog(null, " Bereich [" + Double.toString(MeinDoubleTextFeld.this.xVon).toUpperCase().replace(".", ",") + " ; " + Double.toString(MeinDoubleTextFeld.this.xBis).toUpperCase().replace(".", ",") + "] nicht beachtet !", "Eingabefehler:", 0);
                    MeinDoubleTextFeld.this.setText(String.valueOf(MeinDoubleTextFeld.this.xVon));
                    MeinDoubleTextFeld.this.requestFocus();
                } else {
                    MeinDoubleTextFeld.this.kette = ket0;
                }
            }
            catch (NumberFormatException ex) {
                MeinDoubleTextFeld.this.setText(MeinDoubleTextFeld.this.kette);
                MeinDoubleTextFeld.this.requestFocus();
            }
        }
    }

    class MeinKeyAdapter
    extends KeyAdapter {
        MeinKeyAdapter() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if ("0123456789,.-eE/piw".indexOf(e.getKeyChar(), 0) < 0) {
                e.setKeyChar('\b');
            }
        }
    }
}

