/*
 * Decompiled with CFR 0.152.
 */
package textFelderTools;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public class MeinHexzahlTextFeld
extends JTextField {
    private static final long serialVersionUID = 1L;
    private final String zeichenmengeHexzahl = "0123456789abcdefABCDEF";
    private String erlaubteZeichen = "0123456789abcdefABCDEF";
    private long minimum = 0L;
    private long maximum = Long.MAX_VALUE;
    private long nMin;
    private long nMax;
    private long wert = this.minimum;
    private int radix = 16;
    private int hexLaenge = 8;

    public MeinHexzahlTextFeld() {
        this.setnMin(this.minimum);
        this.setnMax(this.maximum);
        this.addFocusListener(new MeinFocusAdapter());
        this.setDocument(new MeinTextDocumentListener());
    }

    public MeinHexzahlTextFeld(String s) {
        this();
        this.setText(s.toUpperCase());
    }

    public MeinHexzahlTextFeld(String s, String sVon, String sBis) {
        this(s);
        try {
            this.setnMin(Long.parseLong(sVon, this.radix));
            this.minimum = this.getnMin();
            this.setnMax(Long.parseLong(sBis, this.radix));
            this.maximum = this.getnMax();
        }
        catch (NumberFormatException nfe) {
            this.setnMin(this.minimum);
            this.setnMax(this.maximum);
        }
    }

    public long getnMin() {
        return this.nMin;
    }

    public void setnMin(long min) {
        this.nMin = min;
    }

    public long getnMax() {
        return this.nMax;
    }

    public void setnMax(long max) {
        this.nMax = max;
    }

    public void setSuperText(String s) {
        super.setText(s);
    }

    public int getHexLaenge() {
        return this.hexLaenge;
    }

    public void setHexLaenge(int hexLaenge) {
        this.hexLaenge = hexLaenge;
    }

    public long getValue() {
        return this.wert;
    }

    public void setValue(long wertNeu) {
        this.setText(Long.toHexString(wertNeu).toUpperCase());
    }

    @Override
    public void setText(String ketteNeu) {
        try {
            long tmp = Long.parseLong(ketteNeu, this.radix);
            super.setText(this.setzeNullen(ketteNeu.toUpperCase()));
            this.wert = tmp;
        }
        catch (NumberFormatException ex) {
            this.wert = this.minimum;
            super.setText(Long.toString(this.minimum, this.radix).toUpperCase());
        }
    }

    boolean bereichUeberschritten(String ket, long min, long max) {
        long wertLong = Long.valueOf(ket, this.radix);
        System.out.println("Zahl = " + wertLong + " von = " + min + "  bis = " + max);
        long minLong = min;
        long maxLong = max;
        return wertLong < minLong || wertLong > maxLong;
    }

    String setzeNullen(String s) {
        while (s.length() < this.hexLaenge) {
            s = "0" + s;
        }
        return s;
    }

    class MeinFocusAdapter
    extends FocusAdapter {
        MeinFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            MeinHexzahlTextFeld.this.selectAll();
        }

        @Override
        public void focusLost(FocusEvent evt) {
            System.out.println("getText() " + MeinHexzahlTextFeld.this.getText());
            if (MeinHexzahlTextFeld.this.bereichUeberschritten(MeinHexzahlTextFeld.this.getText(), MeinHexzahlTextFeld.this.nMin, MeinHexzahlTextFeld.this.nMax)) {
                JOptionPane.showMessageDialog(null, " Bereich [" + Long.toString(MeinHexzahlTextFeld.this.nMin, MeinHexzahlTextFeld.this.radix).toUpperCase() + " ; " + Long.toString(MeinHexzahlTextFeld.this.nMax, MeinHexzahlTextFeld.this.radix).toUpperCase() + "] nicht beachtet !", "Eingabefehler:", 0);
                MeinHexzahlTextFeld.this.setText(Long.toString(MeinHexzahlTextFeld.this.minimum, MeinHexzahlTextFeld.this.radix));
                MeinHexzahlTextFeld.this.requestFocus();
                MeinHexzahlTextFeld.this.selectAll();
            }
            try {
                MeinHexzahlTextFeld.this.wert = Long.parseLong(MeinHexzahlTextFeld.this.getText(), MeinHexzahlTextFeld.this.radix);
                MeinHexzahlTextFeld.this.setText(Long.toString(MeinHexzahlTextFeld.this.wert, MeinHexzahlTextFeld.this.radix));
                System.out.println("wert: " + MeinHexzahlTextFeld.this.wert + "  text = " + MeinHexzahlTextFeld.this.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Eingabefehler:", 0);
                MeinHexzahlTextFeld.this.setValue(MeinHexzahlTextFeld.this.nMin);
                MeinHexzahlTextFeld.this.requestFocus();
                MeinHexzahlTextFeld.this.selectAll();
            }
        }
    }

    class MeinTextDocumentListener
    extends DefaultStyledDocument {
        private static final long serialVersionUID = 1L;

        MeinTextDocumentListener() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] strA = str.toCharArray();
            int i = strA.length - 1;
            while (i > -1) {
                if (MeinHexzahlTextFeld.this.erlaubteZeichen.indexOf(strA[i]) > -1) {
                    super.insertString(offs, "" + Character.toUpperCase(strA[i]), a);
                } else {
                    System.out.print(String.valueOf(strA[i]) + " ist falsches Zeichen");
                    System.out.println("    Zeichenmenge: " + MeinHexzahlTextFeld.this.erlaubteZeichen);
                }
                --i;
            }
        }
    }
}

