/*
 * Decompiled with CFR 0.152.
 */
package textFelderTools;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import zahlenParser.ZahlenParser;

public class MeinNatzahlTextFeld
extends JTextField {
    private static final long serialVersionUID = 1L;
    private String zeichenmengeNatzahlen;
    private String erlaubteZeichen;
    private int minimum;
    private int maximum;
    private int nMin;
    private int nMax;
    private int wert;
    private int radix;

    public MeinNatzahlTextFeld() {
        this.erlaubteZeichen = this.zeichenmengeNatzahlen = "0123456789";
        this.minimum = 0;
        this.maximum = Integer.MAX_VALUE;
        this.wert = this.minimum;
        this.radix = 10;
        super.setBorder(new LineBorder(new Color(171, 173, 179), 2, true));
        this.setnMin(this.minimum);
        this.setnMax(this.maximum);
        this.addFocusListener(new MeinFocusAdapter());
        this.setDocument(new MeinTextDocumentListener());
    }

    public MeinNatzahlTextFeld(String s) {
        this();
        this.setText(s.toUpperCase());
    }

    public MeinNatzahlTextFeld(String s, String sVon, String sBis) {
        this(s);
        try {
            this.setnMin(Integer.parseInt(sVon));
            this.minimum = this.getnMin();
            this.setnMax(Integer.parseInt(sBis));
            this.maximum = this.getnMax();
        }
        catch (NumberFormatException nfe) {
            this.setnMin(this.minimum);
            this.setnMax(this.maximum);
        }
    }

    @Override
    public void setText(String ketteNeu) {
        try {
            int tmp = Integer.parseInt(ketteNeu, this.radix);
            super.setText(Integer.toString(tmp, this.radix).toUpperCase());
            this.wert = tmp;
        }
        catch (NumberFormatException ex) {
            this.wert = this.minimum;
            super.setText(Integer.toString(this.minimum, this.radix).toUpperCase());
        }
    }

    public int getValue() {
        return this.wert;
    }

    public void setValue(int wertNeu) {
        this.setText(Integer.toString(wertNeu, this.radix).toUpperCase());
    }

    public int getnMin() {
        return this.nMin;
    }

    public void setnMin(int min) {
        this.nMin = min;
    }

    public int getnMax() {
        return this.nMax;
    }

    public void setnMax(int max) {
        this.nMax = max;
    }

    public void setRadix(int rad) {
        this.radix = rad;
    }

    public void setSuperText(String s) {
        super.setText(s);
    }

    public void setZeichenmenge(String zchnMenge) {
        this.erlaubteZeichen = zchnMenge;
    }

    boolean bereichUeberschritten(String ket, int min, int max) {
        long wertLong = Long.valueOf(ket, this.radix);
        long minLong = Long.valueOf(Integer.toString(min));
        long maxLong = Long.valueOf(Integer.toString(max));
        return wertLong < minLong || wertLong > maxLong;
    }

    class MeinFocusAdapter
    extends FocusAdapter {
        MeinFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            MeinNatzahlTextFeld.this.selectAll();
        }

        @Override
        public void focusLost(FocusEvent evt) {
            while (MeinNatzahlTextFeld.this.getText().startsWith("0") && MeinNatzahlTextFeld.this.getText().length() > 1) {
                MeinNatzahlTextFeld.this.setText(MeinNatzahlTextFeld.this.getText().substring(1));
            }
            if (MeinNatzahlTextFeld.this.getText().length() == 0) {
                MeinNatzahlTextFeld.this.setValue(MeinNatzahlTextFeld.this.nMin);
                MeinNatzahlTextFeld.this.requestFocus();
            }
            if (MeinNatzahlTextFeld.this.bereichUeberschritten(MeinNatzahlTextFeld.this.getText(), MeinNatzahlTextFeld.this.nMin, MeinNatzahlTextFeld.this.nMax)) {
                JOptionPane.showMessageDialog(null, " Bereich [" + Integer.toString(MeinNatzahlTextFeld.this.nMin, MeinNatzahlTextFeld.this.radix).toUpperCase() + " ; " + Integer.toString(MeinNatzahlTextFeld.this.nMax, MeinNatzahlTextFeld.this.radix).toUpperCase() + "] nicht beachtet !", "Eingabefehler:", 0);
                MeinNatzahlTextFeld.this.setText(Integer.toString(MeinNatzahlTextFeld.this.minimum, MeinNatzahlTextFeld.this.radix));
                MeinNatzahlTextFeld.this.requestFocus();
                MeinNatzahlTextFeld.this.selectAll();
            }
            try {
                if (MeinNatzahlTextFeld.this.getText().startsWith("-")) {
                    MeinNatzahlTextFeld.this.wert = ZahlenParser.parseIntegerAc(MeinNatzahlTextFeld.this.getText());
                } else {
                    MeinNatzahlTextFeld.this.wert = ZahlenParser.parseIntegerAc(MeinNatzahlTextFeld.this.getText(), MeinNatzahlTextFeld.this.radix);
                }
                MeinNatzahlTextFeld.this.setText(Integer.toString(MeinNatzahlTextFeld.this.wert, MeinNatzahlTextFeld.this.radix));
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Eingabefehler:", 0);
                MeinNatzahlTextFeld.this.setValue(MeinNatzahlTextFeld.this.nMin);
                MeinNatzahlTextFeld.this.requestFocus();
                MeinNatzahlTextFeld.this.selectAll();
            }
        }
    }

    class MeinTextDocumentListener
    extends DefaultStyledDocument {
        private static final long serialVersionUID = 1L;

        MeinTextDocumentListener() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] strA = str.toCharArray();
            int i = strA.length - 1;
            while (i > -1) {
                if (MeinNatzahlTextFeld.this.erlaubteZeichen.indexOf(strA[i]) > -1) {
                    super.insertString(offs, "" + strA[i], a);
                } else {
                    System.out.println(String.valueOf(strA[i]) + " ist falsches Zeichen");
                    System.out.println("Zeichenmenge: " + MeinNatzahlTextFeld.this.erlaubteZeichen);
                }
                --i;
            }
        }
    }
}

