/*
 * Decompiled with CFR 0.152.
 */
package zahlenParser;

public class ZahlenParser {
    static long oGrenze = Long.MAX_VALUE;
    static long uGrenze = Long.MIN_VALUE;
    static int lenoGrenze = Long.toString(oGrenze).length();
    static int lenuGrenze = Long.toString(uGrenze).length();
    static int oIGrenze = Integer.MAX_VALUE;
    static int uIGrenze = Integer.MIN_VALUE;
    static int lenoIGrenze = Integer.toString(oIGrenze).length();
    static int lenuIGrenze = Integer.toString(uIGrenze).length();
    static String zeichenmengeBasisUr;
    static String zeichenmengeBasis;

    static {
        zeichenmengeBasis = zeichenmengeBasisUr = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    }

    public static long parseLongAc(String s) throws NumberFormatException {
        long grenze;
        int len = s.length();
        if (s.equals(null) || len == 0) {
            throw new NumberFormatException("keine Ziffern vorhanden");
        }
        long zahl = 0L;
        int i = 0;
        boolean negativ = false;
        if (s.charAt(0) == '-') {
            if (len == 1) {
                throw new NumberFormatException("nur -, aber keine Ziffern vorhanden");
            }
            if (len > lenuGrenze) {
                throw new NumberFormatException("-2^63 unterschritten");
            }
            negativ = true;
            grenze = uGrenze;
            ++i;
        } else {
            if (len > lenoGrenze) {
                throw new NumberFormatException("2^63-1 \u00fcberschritten");
            }
            grenze = -oGrenze;
        }
        while (i < len) {
            int ziffer = s.charAt(i) - 48;
            if (!Character.isDigit(s.charAt(i))) {
                throw new NumberFormatException("keine Ziffer");
            }
            if ((zahl *= 10L) > 0L) {
                throw new NumberFormatException("2^63-1  \u00fcberschritten");
            }
            if (zahl < grenze + (long)ziffer) {
                throw new NumberFormatException("Longzahlbereich \u00fcberschritten");
            }
            zahl -= (long)ziffer;
            ++i;
        }
        if (negativ) {
            return zahl;
        }
        return -zahl;
    }

    public static int parseIntegerAc(String s) {
        int grenze;
        int len = s.length();
        if (s.equals(null) || len == 0) {
            throw new NumberFormatException("keine Ziffern vorhanden");
        }
        int zahl = 0;
        int i = 0;
        boolean negativ = false;
        if (s.charAt(0) == '-') {
            if (len == 1) {
                throw new NumberFormatException("nur -, aber keine Ziffern vorhanden");
            }
            if (len > lenuIGrenze) {
                throw new NumberFormatException("-2147483648 unterschritten");
            }
            negativ = true;
            grenze = uIGrenze;
            ++i;
        } else {
            if (len > lenoIGrenze) {
                throw new NumberFormatException("2147483647 \u00fcberschritten");
            }
            grenze = -oIGrenze;
        }
        while (i < len) {
            int ziffer = s.charAt(i) - 48;
            if (!Character.isDigit(s.charAt(i))) {
                throw new NumberFormatException("keine Ziffer");
            }
            if ((zahl *= 10) > 0) {
                throw new NumberFormatException("2147483647  \u00fcberschritten");
            }
            if (zahl < grenze + ziffer) {
                throw new NumberFormatException("Integerzahlbereich \u00fcberschritten");
            }
            zahl -= ziffer;
            ++i;
        }
        if (negativ) {
            return zahl;
        }
        return -zahl;
    }

    public static void setZeichenmengeBasis(int basis) {
        zeichenmengeBasis = zeichenmengeBasisUr.substring(0, basis);
    }

    public static int maxStellen(int basis) {
        return (int)Math.ceil(Math.log(2.0) / Math.log(basis) * 63.0);
    }

    public static long parseLongAc(String s, int basis) throws NumberFormatException {
        int len = s.length();
        if ((s = s.toUpperCase()).equals(null) || len == 0) {
            throw new NumberFormatException("keine Zahl eingegeben");
        }
        long grenze = Long.MAX_VALUE;
        int lenGrenze = ZahlenParser.maxStellen(basis);
        if (len > lenGrenze) {
            throw new NumberFormatException("Zahl zu gro\u00df");
        }
        long zahl = 0L;
        int i = 0;
        ZahlenParser.setZeichenmengeBasis(basis);
        while (i < len) {
            char ch = s.charAt(i);
            if (zeichenmengeBasis.indexOf(ch, 0) < 0) {
                throw new NumberFormatException("falsche Ziffern");
            }
            int ziffer = ch > '@' ? ch - 55 : ch - 48;
            if ((zahl = (long)basis * zahl) < 0L) {
                throw new NumberFormatException("2^63-1  \u00fcberschritten");
            }
            if (zahl > grenze - (long)ziffer) {
                throw new NumberFormatException("2^63-1  \u00fcberschritten");
            }
            zahl += (long)ziffer;
            ++i;
        }
        return zahl;
    }

    public static int maxStellenInt(int basis) {
        return (int)Math.ceil(Math.log(2.0) / Math.log(basis) * 31.0);
    }

    public static int parseIntegerAc(String s, int basis) throws NumberFormatException {
        int len = s.length();
        if ((s = s.toUpperCase()).equals(null) || len == 0) {
            throw new NumberFormatException("keine Zahl eingegeben");
        }
        int grenze = Integer.MAX_VALUE;
        int lenGrenze = ZahlenParser.maxStellenInt(basis);
        if (len > lenGrenze) {
            throw new NumberFormatException("2147483647 \u00fcberschritten");
        }
        int zahl = 0;
        int i = 0;
        ZahlenParser.setZeichenmengeBasis(basis);
        while (i < len) {
            char ch = s.charAt(i);
            if (zeichenmengeBasis.indexOf(ch, 0) < 0) {
                throw new NumberFormatException("falsche Ziffern");
            }
            int ziffer = ch > '@' ? ch - 55 : ch - 48;
            if ((zahl = basis * zahl) < 0) {
                throw new NumberFormatException("2147483647  \u00fcberschritten");
            }
            if (zahl > grenze - ziffer) {
                throw new NumberFormatException("2147483647  \u00fcberschritten");
            }
            zahl += ziffer;
            ++i;
        }
        return zahl;
    }

    public static double parseDoubleAc(String s) {
        int len = s.length();
        if (s.equals(null) || len == 0) {
            throw new NumberFormatException("keine Ziffern vorhanden");
        }
        double zahl = 0.0;
        zahl = Double.parseDouble(s);
        if (zahl == Double.POSITIVE_INFINITY) {
            throw new NumberFormatException("plus Unendlich");
        }
        if (zahl == Double.NEGATIVE_INFINITY) {
            throw new NumberFormatException("minus Unendlich");
        }
        return zahl;
    }
}

